<?php
	
	include'admin/section/functions.php';
	include'section/meta.php';
	include'section/css.php';	
	include'section/navbar.php';
	
?>


<section class="banner-other"  style="background-image: url(<?php echo"$url_domain/images/bg-quran.png";?>);">
	<div class="container">
		<div class="d-flex align-items-center">
			<div class="text-center w-50">
				<h4 class="text-dark m-0">Quran by Subjects</h4>
				<h6 class="text-dark m-0">2005 Subjects in total</h6>
			</div>
			<div class="text-center w-50">
					<h1 class="text-dark font-arabic2 m-0">مضامینِ قرآن</h1>
			</div>
		</div>
	</div>
</section>

<section class="py-3">
	<div class="container">
		<div class="row">
			

<?php
	if($get_language == 'eng'){

		$table_name	= "SELECT *, count(ayat_number) as count_verse FROM quran_subject_eng group by topic_id order by id";
		$targetpage = "$url_domain/alquran-subjects/$get_language/";
		$rowlimit 	= 50;
		$pagination_result = pagination($table_name,$targetpage,$rowlimit);
		
		$sr = 1;
		$query = "$table_name LIMIT $pagination_result[0], $rowlimit";
		$q_result = mysqli_query($connect_database, $query) or die (mysqli_error());
		if(mysqli_num_rows($q_result) != 0)
				{
					while($row = mysqli_fetch_assoc($q_result))
					{
						$sr_id 						= $row['id'];
						$subject_surat_id 			= $row['surat_id'];
						$subject_ayat_number 		= $row['ayat_number'];
						$subject_topic_id			= $row['topic_id'];
						$subject_topic				= $row['topic'];
						
						$subject_count_verse		= $row['count_verse'];
						
						
						
						echo'<div class="col-md-6">
								<div class="d-flex align-items-center mb-3">
									<div class="text-left"><div style="width:30px;" class="text-gray d-none d-md-block">'.$subject_topic_id.'</div></div>
									<a href="'.$url_domain.'/alquran-sub-topic/'.$get_language.'/'.$subject_topic_id.'/0" class="w-100 btn btn-outline-light white-space-normal py-2 px-3 btn-white m-0">
										<div class="text-left">
											<div class="text-primary">'.$subject_topic.'</div>
											<div class="text-secondary small">'.$subject_count_verse.' Verse(s)</div>
										</div>
									</a>
								</div>
							</div>';
					$sr++;
					}
				}
				
				
				
	}else if($get_language == 'urd'){
		
		
		$table_name	= "SELECT *, count(ayat_number) as count_verse FROM quran_subject_urd group by topic_id order by id";
		$targetpage = "$url_domain/alquran-subjects/$get_language/";
		$rowlimit 	= 50;
		$pagination_result = pagination($table_name,$targetpage,$rowlimit);
		
		$sr = 1;
		$query = "$table_name LIMIT $pagination_result[0], $rowlimit";
		$q_result = mysqli_query($connect_database, $query) or die (mysqli_error());
		if(mysqli_num_rows($q_result) != 0)
				{
					while($row = mysqli_fetch_assoc($q_result))
					{
						$sr_id 						= $row['id'];
						$subject_surat_id 			= $row['surat_id'];
						$subject_ayat_number 		= $row['ayat_number'];
						$subject_topic_id			= $row['topic_id'];
						$subject_topic				= $row['topic'];
						
						$subject_count_verse		= $row['count_verse'];
						
						
						
						echo'<div class="col-md-6">
								<div class="d-flex align-items-center mb-3">
									<a href="'.$url_domain.'/alquran-sub-topic/'.$get_language.'/'.$subject_topic_id.'/0" class="w-100 btn btn-outline-light white-space-normal py-2 px-3 m-0">
										<div class="text-right">
											<div class="font-arabic2 h4 m-0 text-primary">'.$subject_topic.'</div>
											<div class="font-arabic2 h5 m-0 text-secondary">'.$subject_count_verse.' آیات</div>
										</div>
									</a>
									<div class="text-right"><div style="width:30px;" class="text-gray d-none d-md-block">'.$subject_topic_id.'</div></div>
								</div>
							</div>';
					$sr++;
					}
				}
		
	}
?>


			
		</div>
	</div>
</section>


<?php
	if(!empty($pagination_result[1])){
		echo'<section class="bg-gray py-3">
				<div class="container text-center">
					'.$pagination_result[1].'
				</div>
			</section>';
	}
?>


<?php
	include'section/footer.php';
	include'section/script.php';
?>